/*******************************************************
Filename		:  	DW_process_batch_requests.sql
Release 		:  	STORET c2.0.5
SIR			:  	1633
Description		:  	Processes the overnight batch and pending immediate batch data requests.
Author		:	Ganesh Thadkamalla
Date			: 	August 11, 2005
Comments		:  	
**********************************************************/
create or replace procedure DW_process_batch_requests
is 

cursor batch_cur is
select * from dw_data_requests
where 
(request_mode='Overnight'
 and  upper(request_status)='NEW')
or (request_mode='Immediate'
 and  upper(request_status)!='COMPLETED'
 AND DATETIME < (SYSDATE- (8/24)) );


lv_req_status dw_data_requests.request_status%type;

begin

for batch_cvar in batch_cur loop
  dw_process_data_request(batch_cvar.request_id);
end loop;
end;
/
